<?php
class Software { private $db; private $id; private $name; private $type; private $difficulty; private $popularity; private $cracked; private $price; public function __construct($data = null) { $this->db = Database::getInstance(); if ($data) { $this->loadFromData($data); } } private function loadFromData($data) { $this->id = $data['id'] ?? null; $this->name = $data['name']; $this->type = $data['type']; $this->difficulty = $data['difficulty']; $this->popularity = $data['popularity']; $this->cracked = $data['cracked']; $this->price = $data['price']; } public static function getAvailableSoftware() { $db = Database::getInstance(); $result = $db->query("SELECT * FROM software WHERE cracked = 0")->fetchAll(PDO::FETCH_ASSOC); $software = []; foreach ($result as $data) { $software[] = new Software($data); } return $software; } public static function getCrackedSoftware() { $db = Database::getInstance(); $result = $db->query("SELECT * FROM software WHERE cracked = 1")->fetchAll(PDO::FETCH_ASSOC); $software = []; foreach ($result as $data) { $software[] = new Software($data); } return $software; } public function save() { if ($this->id) { $this->db->query( "UPDATE software SET
                name = ?,
                type = ?,
                difficulty = ?,
                popularity = ?,
                cracked = ?,
                price = ?
                WHERE id = ?", [ $this->name, $this->type, $this->difficulty, $this->popularity, $this->cracked, $this->price, $this->id ] ); } else { $this->db->query( "INSERT INTO software (name, type, difficulty, popularity, cracked, price)
                VALUES (?, ?, ?, ?, ?, ?)", [ $this->name, $this->type, $this->difficulty, $this->popularity, $this->cracked, $this->price ] ); $this->id = $this->db->lastInsertId(); } } public function crack() { $this->cracked = true; $this->save(); } public function calculateVisitors() { $baseVisitors = $this->popularity * 100; $fluctuation = mt_rand(-10, 10) / 100; return round($baseVisitors * (1 + $fluctuation)); } public function getId() { return $this->id; } public function getName() { return $this->name; } public function getType() { return $this->type; } public function getDifficulty() { return $this->difficulty; } public function getPopularity() { return $this->popularity; } public function isCracked() { return $this->cracked; } public function getPrice() { return $this->price; } public function setName($name) { $this->name = $name; } public function setType($type) { $this->type = $type; } public function setDifficulty($difficulty) { $this->difficulty = $difficulty; } public function setPopularity($popularity) { $this->popularity = $popularity; } public function setPrice($price) { $this->price = $price; } } 